!include "MUI2.nsh"

Name "Invoice Generator"
OutFile "invoice.exe"
!define APP_DIST_PATH "dist"
InstallDir "$LOCALAPPDATA\invoice"
RequestExecutionLevel user

!define MUI_ICON "resources\icons\invoice.ico"
!define MUI_UNICON "resources\icons\invoice.ico"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_LANGUAGE "English"

Section "Install"
    SetOutPath "$INSTDIR"
    File /r "${APP_DIST_PATH}\*.*"
    
    # Rename the executable
    Rename "$INSTDIR\invoice-win_x64.exe" "$INSTDIR\invoice.exe"
    
    CreateDirectory "$SMPROGRAMS\Invoice Generator"
    CreateShortCut "$SMPROGRAMS\Invoice Generator\Invoice Generator.lnk" "$INSTDIR\invoice.exe"
    CreateShortCut "$DESKTOP\Invoice Generator.lnk" "$INSTDIR\invoice.exe"
    
    WriteUninstaller "$INSTDIR\Uninstall.exe"
    
    WriteRegStr HKCU "Software\invoice" "InstallPath" "$INSTDIR"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\invoice" "DisplayName" "Invoice Generator"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\invoice" "UninstallString" "$INSTDIR\Uninstall.exe"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\invoice" "DisplayIcon" "$INSTDIR\invoice.exe"
SectionEnd

Section "Uninstall"
    Delete "$INSTDIR\invoice.exe"
    Delete "$INSTDIR\*.dll"
    RMDir /r "$INSTDIR\resources"
    Delete "$INSTDIR\*.*"
    Delete "$INSTDIR\Uninstall.exe"
    RMDir "$INSTDIR"
    
    Delete "$SMPROGRAMS\Invoice Generator\Invoice Generator.lnk"
    RMDir "$SMPROGRAMS\Invoice Generator"
    Delete "$DESKTOP\Invoice Generator.lnk"
    
    DeleteRegKey HKCU "Software\invoice"
    DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\invoice"
SectionEnd